package com.hero.objects.modifiers;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.EnduranceReserve;
import com.hero.objects.powers.EnduranceReserveRecovery;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class DoubleEnduranceCost extends Modifier {

	private static String xmlID = "DOUBLEENDCOST";

	public DoubleEnduranceCost(Element root) {
		super(root, DoubleEnduranceCost.xmlID);
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);

        if (forceAllow()) return ret;
		if (o instanceof EnduranceReserve) {
			return getDisplay() + " cannot be applied to an " + o.getDisplay();
		}
		if (o instanceof EnduranceReserveRecovery) {
			return getDisplay() + " cannot be applied to an " + o.getDisplay();
		}
		if (o.getEndUsage() == 0) {
			return getDisplay()
					+ " can only be applied to abilities which cost END.";
		}
		if (ret.trim().length() == 0) {
			ret = getDisplay()
					+ " can only be applied to abilities on characters that have an Endurance Reserve.";
			for (GenericObject obj : HeroDesigner.getActiveHero().getPowers()) {
				if (obj instanceof EnduranceReserve) {
					return "";
				} else if (obj instanceof CompoundPower) {
					CompoundPower cp = (CompoundPower) obj;
					for (GenericObject obj2 : cp.getPowers()) {
						if (obj2 instanceof EnduranceReserve) {
							return "";
						}
					}
				}
			}
		}
		return ret;
	}
}